import React, { Component } from 'react'
import Ionicon from 'react-ionicons'
import Loading from '../../../Loading/Loading'
import ReactTable from 'react-table'
import { Form, Text } from 'react-form'
import { Button, Modal, ModalBody, ModalHeader } from 'reactstrap'
import { withApollo } from 'react-apollo'
import gql from 'graphql-tag'
import StadioSviluppoSelect from '../../Fields/StadioSviluppoSelect/StadioSviluppoSelect'
import DeleteButton from '../../../DeleteButton'
import MonitoraggioSpecieRilieviForm from './MonitoraggioSpecieRilieviForm'

class MonitoraggioSpecieRilieviComponent extends Component {

  constructor(props) {
    super(props);
    this.state = {
      columns: [
        {
          Header: "ID Habitat",
          accessor: "idHabitat",
          width: 200,
        },
	 {
         	 Header: "Lon",
          	 accessor: "coordinataX",
         	 width: 70,
        },
	  {
         	Header: "Lat",
          	accessor: "coordinataY",
         	width: 70,
        },
        {
          Header: "Esemplari",
          columns: [
            {
              Header: "M",
              accessor: "esemplariM",
	      width:40,
	      style: {'text-align':'center'}
            },
            {
              Header: "F",
              accessor: "esemplariF",
	      width:40,
	      style: {'text-align':'center'}
            },
            {
              Header: "MF",
              accessor: "esemplariMF",
	      width:40,
	      style: {'text-align':'center'}
            }
          ]
        },
        {
          Header: "Stadio Sviluppo",
          accessor: "stadioSviluppo.etichetta",
	  width: 180,
        },
        {
          Header: "Note",
          accessor: "note",
        },
        {
          Header: "Azioni",
          Cell: (row) => (
            <div style={{display: 'flex', alignItems: 'center'}}>
              <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
                <Button className="btn ionicon-btn btn-light" onClick={() => this.toggleEditModal(row.original)}>
                  <Ionicon icon="ios-create-outline" />
                </Button>
                <DeleteButton id={"delete-" + row.original.id} size={"sm"} onDelete={() => this.onDeleteItem(row.original.id)}>
                  <Ionicon icon="ios-trash-outline" color="#ffffff" />
                </DeleteButton>
              </div>
            </div>
          )
        }
      ],
      submittingReport: false,
      editingReport: null,
      showEditModal: false,
      showCreateModal: false,
      formErrors: null
    };

    this.onDeleteItem = this.onDeleteItem.bind(this)
    this.toggleEditModal = this.toggleEditModal.bind(this)
    this.toggleCreateModal = this.toggleCreateModal.bind(this)
    this.createReport = this.createReport.bind(this)
    this.updateReport = this.updateReport.bind(this)
  }

  toggleCreateModal () {
    const {showCreateModal} = this.state
    this.setState({
      showCreateModal: !showCreateModal,
      editingReport: null
    })
  }

  toggleEditModal (report) {
    const {showEditModal} = this.state
    this.setState({
      showEditModal: !showEditModal,
      editingReport: (!showEditModal?report:null)
    })
  }

  async createReport (values) {
    try {
      const {client} = this.props
      this.setState({submittingReport: true})
      const creationResponse = await client.mutate({
        mutation: gql`mutation($segnalazione: SegnalazioneInput) {
            updateSegnalazione(segnalazione: $segnalazione) {
                id
            }
        }`,
        variables: {
          segnalazione: {
            esemplariF: values.esemplariF ? parseInt(values.esemplariF) : null,
            esemplariM: values.esemplariM ? parseInt(values.esemplariM) : null,
            esemplariMF: values.esemplariMF ? parseInt(values.esemplariMF) : null,
            coordinataX: values.coordinataX? parseFloat(values.coordinataX.replace(/,/g,'.')) : null,
	    coordinataY: values.coordinataY? parseFloat(values.coordinataY.replace(/,/g,'.')) : null,
            stadioSviluppo: {id: values.stadioSviluppo},
	    tipoMarcatura: values.tipoMarcatura?{id: values.tipoMarcatura}:null,
	    tipoRicattura: values.tipoRicattura?{id: values.tipoRicattura}:null,
	    idMarcatura: values.idMarcatura,
	    idRicattura: values.idRicattura,
            note: values.note,
	    idHabitat: values.idHabitat
          }
        }
      })
      if (creationResponse.data && creationResponse.data.updateSegnalazione) {
        const addMonitoraggioSpecieSegnalazioneResponse = await client.mutate({
          mutation: gql`mutation($segnalazione: SegnalazioneInput, $monitoraggioSpecie: MonitoraggioSpecieInput) {
              addMonitoraggioSpecieSegnalazione(segnalazione: $segnalazione, monitoraggioSpecie: $monitoraggioSpecie) {
                  id
              }
          }`,
          variables: {
            segnalazione: {
              id: creationResponse.data.updateSegnalazione.id
            },
            monitoraggioSpecie: {
              id: this.props.data.monitoraggioSpecie.id
            }
          }
        })
        this.props.data.refetch()
        this.setState({
          submittingReport: false,
          showCreateModal: false
        })
      } else {
        this.setState({
          formErrors: "Errore durante la creazione del rilievo",
          submittingReport: false
        })
      }
      this.setState({submittingReport: false})
    } catch (e) {
      this.setState({submittingReport: false})
      console.error(e)
    }
  }

  async updateReport (values) {
    try {
      const {client} = this.props
      const {editingReport} = this.state
      this.setState({submittingReport: true})
      const updateResponse = await client.mutate({
        mutation: gql`mutation($segnalazione: SegnalazioneInput) {
            updateSegnalazione(segnalazione: $segnalazione) {
                id
            }
        }`,
        variables: {
          segnalazione: {
            id: editingReport.id,
            esemplariF: values.esemplariF ? parseInt(values.esemplariF) : null,
            esemplariM: values.esemplariM ? parseInt(values.esemplariM) : null,
            esemplariMF: values.esemplariMF ? parseInt(values.esemplariMF) : null,
	    coordinataX: values.coordinataX? parseFloat(values.coordinataX.replace(/,/g,'.')) : null,
	    coordinataY: values.coordinataY? parseFloat(values.coordinataY.replace(/,/g,'.')) : null,
            stadioSviluppo: {id: values.stadioSviluppo},
	    monitoraggioSpecie: {
              id: this.props.data.monitoraggioSpecie.id
            },
            note: values.note,
 	    idHabitat: values.idHabitat,
	    tipoMarcatura: values.tipoMarcatura?{id: values.tipoMarcatura}:null,
	    tipoRicattura: values.tipoRicattura?{id: values.tipoRicattura}:null,
	    idMarcatura: values.idMarcatura,
	    idRicattura: values.idRicattura,
          }
        }
      })
      this.setState({
        submittingReport: false,
        showEditModal: false
      })
      this.props.data.refetch()
    } catch (e) {
      this.setState({submittingReport: false})
      console.error(e)
    }
  }

  async onDeleteItem(id) {
    const { client } = this.props

    const result = await client.mutate({
      mutation: gql`mutation($segnalazione: SegnalazioneInput, $monitoraggioSpecie: MonitoraggioSpecieInput) {
          removeMonitoraggioSpecieSegnalazione(segnalazione: $segnalazione, monitoraggioSpecie: $monitoraggioSpecie) {
              id
          }
      }`,
      variables: {
        segnalazione: {
          id: id
        },
        monitoraggioSpecie: {
          id: this.props.data.monitoraggioSpecie.id
        }
      }
    })
    this.props.data.refetch()
  }

  render() {
    const {
      data,
    } = this.props;

    const {
      columns,
      showEditModal,
      showCreateModal,
      submittingReport,
      editingReport,
      formErrors
    } = this.state;

    if(data.error) {
      return(
        <div className="text-danger">
          Errore nella ricezione dei dati
        </div>
      )
    }

    if(data.loading) {
      return (
        <Loading/>
      )
    }

    return (
      <div className="container-fluid">
        <div className="btn-toolbar" style={{backgroundColor: '#fff'}}>
          <div className="btn-group mr-2">
            <button className="btn ionicon-btn btn-light" onClick={this.toggleCreateModal} type="button">
              <Ionicon icon="ios-add-circle-outline" style={{marginRight: '5px', marginLeft: '-8px'}} />
              Aggiungi rilievo
            </button>
          </div>
        </div>
        <ReactTable
          loading={data.loading}
          noDataText={"Nessun rilievo presente"}
          className="-highlight"
          data={data.monitoraggioSpecie.segnalazioni}
          style={{}}
          defaultPageSize={100}
	  minRows={3}
	  showPagination={false}
          nextText="Avanti"
          previousText="Indietro"
          loadingText="Caricamento in corso..."
          rowsText="elementi"
          ofText="di"
          pageText="Pagina"
          columns={columns} />

        <Modal isOpen={showCreateModal} toggle={this.toggleCreateModal}>
          <ModalHeader toggle={this.toggleCreateModal}>
            Aggiungi Rilievo
          </ModalHeader>
          <ModalBody>
            <MonitoraggioSpecieRilieviForm
              onSubmit={this.createReport}
              submitting={submittingReport}
            />
          </ModalBody>
        </Modal>

        <Modal isOpen={showEditModal} toggle={this.toggleEditModal}>
          <ModalHeader toggle={this.toggleEditModal}>
            Modifica Rilievo
          </ModalHeader>
          <ModalBody>
            {editingReport && (
              <MonitoraggioSpecieRilieviForm
                formValues={{
                  ...editingReport,
                  stadioSviluppo: editingReport.stadioSviluppo.id,
		  tipoMarcatura: editingReport.tipoMarcatura?editingReport.tipoMarcatura.id : null,
		  tipoRicattura: editingReport.tipoRicattura?editingReport.tipoRicattura.id : null,
		  coordinataX: editingReport.coordinataX?(''+editingReport.coordinataX).replace(/\./g,','):null,
		  coordinataY: editingReport.coordinataY?(''+editingReport.coordinataY).replace(/\./g,','):null,
                }}
                onSubmit={this.updateReport}
                submitting={submittingReport}
              />
            )}
          </ModalBody>
        </Modal>
      </div>
    )
  }
}

const MonitoraggioSpecieRilievi = withApollo(MonitoraggioSpecieRilieviComponent)

export default MonitoraggioSpecieRilievi
